<?php

namespace App\Http\Controllers\Owner\BookingExtraPassenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\BookingExtraPassenger\Application\Reset\ResetBookingExtraPassengerQuery;
use App\Modules\BookingExtraPassenger\Application\Reset\ResetBookingExtraPassengerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Illuminate\Support\Facades\DB;

class BookingExtraPassengerResetController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "BookingExtraPassenger";
        $this->history = new HistoryData(HistoryTables::BOOKING_EXTRA_PASSENGER);
    }

    public static function findBooking($Id_BookingExtraPassenger)
    {
        $found = DB::select('SELECT `fn_booking_tour_detail_passenger_find_booking`(?,?) as Id_Booking', [$Id_BookingExtraPassenger, 2]);
        return count($found) ? $found[0]->Id_Booking : null;
    }

    public function __invoke(Request $request, $Id)
    {
        $this->history->obtainOld($Id);
        /** @var ResetBookingExtraPassengerResponse $response */
        $response = $this->queryBus->ask(new ResetBookingExtraPassengerQuery($Id));
        $this->history->update($this->findBooking($Id), $this->history->oldValue, [], $request);
        return ResponseBuilder::Response($response->response());
    }
}
