<?php

namespace App\Http\Controllers\Owner\BookingExtraPassenger;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\BookingExtraPassenger\Infrastructure\BookingExtraPassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Support\Facades\DB;

class BookingExtraPassengerMassiveUpdateController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "BookingExtraPassenger";
        $this->history = new HistoryData(HistoryTables::BOOKING_EXTRA_PASSENGER);
    }

    public static function findBooking($Id_BookingExtraPassenger)
    {
        $found = DB::select('SELECT `fn_booking_tour_detail_passenger_find_booking`(?,?) as Id_Booking', [$Id_BookingExtraPassenger, 2]);
        return count($found) ? $found[0]->Id_Booking : null;
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate($request->all(), 'Booking', BookingExtraPassengerValidators::MASSIVE_UPDATE);

        foreach ($request->input('BookingExtraPassenger') as $bep) {
            $response = $this->saveBookingExtraPassenger($bep, $request);
            if ($response['Response_Status'] !== 200) {
                ResponseBuilder::Response($response);
            }
        }

        return ResponseBuilder::Response($response);
    }

    private function saveBookingExtraPassenger($idBookingExtraPassenger, $request)
    {

        $this->history->obtainOld($idBookingExtraPassenger);

        $oParam = array(
            $request->input("BookingExtraPassenger_DateEntryStart") . ' ' . $request->input("BookingExtraPassenger_HourEntryStart") . ':00',
            $request->input("BookingExtraPassenger_DateEntryStart") . ' ' . $request->input("BookingExtraPassenger_HourEntryEnd") . ':00',
            $request->input('BookingExtraPassenger_DatePurchase'),
            $request->input("BookingExtraPassenger_Code"),
            $request->input("BookingExtraPassenger_Amount"),
            $request->input("BookingExtraPassenger_Remark"),
            $request->header("Token"),
            $idBookingExtraPassenger
        );
        $oData = DB::select('call sp_booking_extra_passenger_update(?,?,?,?,?,?,?,?)', $oParam);

        if ($oData[0]->Response_Success == 1) {
            $this->history->update(
                $this->findBooking($request->input("Id_BookingExtraPassenger")),
                $this->history->oldValue,
                [$request->all()],
                $request
            );
        }

        return [
            'Response_Status'           => $oData[0]->Response_Status,
            'Response_Code'             => $oData[0]->Response_Code,
            'Response_Domain'           => $this->domain,
            'Response_Message'          => $oData[0]->Response_Message,
            'Response_Data'             => null,
            'Response_Error_Message'    => $oData[0]->Response_Message,
            'Response_Error_Reason'     => $oData[0]->Response_Reason,
        ];
    }
}
