<?php

namespace App\Http\Controllers\Owner\BookingExtraPassenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\BookingExtraPassenger\Application\Mask\MaskBookingExtraPassengerQuery;
use App\Modules\BookingExtraPassenger\Application\Mask\MaskBookingExtraPassengerResponse;
use App\Modules\BookingExtraPassenger\Infrastructure\BookingExtraPassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Support\Facades\DB;

class BookingExtraPassengerMaskController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "BookingExtraPassenger";
        $this->history = new HistoryData(HistoryTables::BOOKING_EXTRA_PASSENGER);
    }

    public static function findBooking($Id_BookingExtraPassenger)
    {
        $found = DB::select('SELECT `fn_booking_tour_detail_passenger_find_booking`(?,?) as Id_Booking', [$Id_BookingExtraPassenger, 2]);
        return count($found) ? $found[0]->Id_Booking : null;
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate($request->all(), 'Booking', BookingExtraPassengerValidators::MASK);

        $this->history->obtainOld($request->input('Id_BookingExtraPassenger'));

        /** @var MaskBookingExtraPassengerResponse $response */
        $response = $this->queryBus->ask(new MaskBookingExtraPassengerQuery(
            $request->input('Id_BookingExtraPassenger'),
            $request->input('BookingExtraPassenger_Mask')
        ));

        $this->history->update($this->findBooking($request->input('Id_BookingExtraPassenger')), $this->history->oldValue, [], $request);
        return ResponseBuilder::Response($response->response());
    }
}
