<?php

namespace App\Http\Controllers\Owner\BookingExtraPassenger;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\BookingExtraPassenger\Application\BookingExtraPassengerResponses;
use App\Modules\BookingExtraPassenger\Application\ListById\ListByIdBookingExtraPassengerQuery;
use App\Modules\BookingExtraPassenger\Infrastructure\BookingExtraPassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;

class BookingExtraPassengerByIdsController extends Controller
{
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->history = new HistoryData(HistoryTables::BOOKING_EXTRA_PASSENGER);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate($request->all(), 'Booking', BookingExtraPassengerValidators::LIST_BY_IDS);
        /** @var BookingExtraPassengerResponses $response */
        $response = $this->queryBus->ask(new ListByIdBookingExtraPassengerQuery($request->input('Ids')));
        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->data()));
    }
}
