<?php

namespace App\Http\Controllers\Owner\BookingAssign;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\BookingAssign\Application\Create\CreateBookingAssignQuery;
use App\Modules\BookingAssign\Application\Create\CreateBookingAssignResponse;
use App\Modules\BookingAssign\Infraestructure\BookingAssignValidators;

class BookingAssignInsertController extends Controller
{
    private $domain;

    private HistoryData $history;
    private HistoryData $historyBooking;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "BookingAssign";
        $this->history = new HistoryData(HistoryTables::BOOKING_ASSIGN);
        $this->historyBooking = new HistoryData(HistoryTables::BOOKING);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, BookingAssignValidators::INSERT);

        $this->historyBooking->obtainOld($request->input('Id_Booking'));
        /** @var CreateBookingAssignResponse $response */
        $response = $this->queryBus->ask(new CreateBookingAssignQuery(
            $request->input('BookingAssign_Remark'),
            $request->input('BookingAssign_Status'),
            $request->input('Id_Booking'),
            $request->input('Id_Admin'),
            $request->input('Id_TypeBookingAssign')
        ));
        $this->history->insertBasic($request, $response->response()['Response_Data']['Id']);
        $this->historyBooking->update($request->input('Id_Booking'), $this->historyBooking->oldValue, [], $request);

        return ResponseBuilder::Response($response->response());
    }
}
