<?php

namespace App\Http\Controllers\Mail;

use App\Http\Controllers\Controller;


class c_Mail_Booking_Body extends Controller
{
    private $Style_Base         = "display: block; height: auto; width: 100%; box-sizing: border-box; margin: 0px; padding: 5px 0px;";

    private $Style_Base_2       = "height: auto; border-box; margin: 0px; padding: 5px 0px;";
    private $Font_Family        = "Segoe, 'Segoe UI', 'DejaVu Sans', 'Trebuchet MS', Verdana, 'sans-serif'";

    private $Color_Primary      = "#f56a2a";
    private $Color_Secondary    = "#f56a2a";

    private $Color_White        = "#FCFCFC";
    private $Color_White_Light  = "#FFFFFF";
    private $Color_White_Dark   = "#F3F3F3";

    public $Color_Black     = "#777777";
    private $Color_Black_Light  = "#999999";
    private $Color_Black_Dark   = "#222222";

    private $Color_Blue         = "#007aff";
    private $Color_Green        = "#34c759";
    private $Color_Indigo       = "#5856d6";
    private $Color_Orange       = "#ff9500";
    private $Color_Pink         = "#ff2d55";
    private $Color_Purple       = "#af52de";
    private $Color_Red          = "#ff3b30";
    private $Color_Teal         = "#5ac8fa";
    private $Color_Yellow       = "#ffcc00";

    private $Padding            = "5px 20px";
    private $Margin             = "10px 0";


    public function Get_Body()
    {
        $Body = "
        <!doctype html>
        <html lang=\"es\">
        <head>
            <meta charset=\"UTF-8\">
            <meta name=\"viewport\" content=\"width=device-width, user-scalable=no, initial-scale=1.0\">
        </head> 
        <body style=\"background: $this->Color_White_Dark; padding: 30px 0;\">
            <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"width=100%; max-width=600px\">
                <tr style=\"background: $this->Color_White\">
                    <td>
                        <img src=\"[[MEDIA_HEADER]]\" style=\"width: 100%; height: auto; \"/>
                    </td>
                </tr>
                <tr style=\"background: $this->Color_White\">
                    <td style=\"padding: 0;\">
                        [[CONTENT]]
                    </td>
                </tr>
                <tr>
                    <td>
                        
                    </td>
                </tr>
                <tr style=\"background: $this->Color_White_Dark;\">
                    <td>
                        <p style=\"$this->Style_Base padding: $this->Padding; font-family: $this->Font_Family; font-size: 12px; color: $this->Color_Black_Light; text-align: center;\">
                            © Salkantay Trekking.
                        </p>
                    </td>
                </tr>
            </table>

        </body>
        </html>
        ";

        return $Body;
    }

    public function Get_Booking_Body($reduce = 1)
    {
        $Body = "
        <!doctype html>
        <html lang=\"es\">
        <head>
            <meta charset=\"UTF-8\">
            <meta name=\"viewport\" content=\"width=device-width, user-scalable=no, initial-scale=1.0\">
        </head> 
        <body style=\"background: $this->Color_White_Light; padding: 0px 0px;\">
            <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"width:100%; max-width:600px\">
                <tr>
                    <td>
                        <img src=\"[[MEDIA_HEADER]]\" style=\"width: 100%; height: auto; \"/>
                    </td>
                </tr>
                <tr>
                    <td style=\"margin: 0px auto;\">
                        [[CONTENT]]
                    </td>
                </tr>
                <tr style=\"margin: 0px auto; background-color: $this->Color_Black_Dark;\">
                    <td style=\"margin: 0px auto;\">
                        <p style=\"$this->Style_Base padding: $this->Padding; font-family: $this->Font_Family; font-size: " . ($reduce * 12) .
            "px; color: $this->Color_White; text-align: center;\">
                            © Salkantay Trekking.
                        </p>
                    </td>
                </tr>
                <tr style=\"\">
                    <td style=\"margin: 0px auto;\">
                        <p style=\"$this->Style_Base padding: $this->Padding; font-family: $this->Font_Family; font-size: " . ($reduce * 12) .
            "px; color: $this->Color_Black_Light;\">
                            ** You received this email because you made a purchase, reservation, or other service on our website that requires your confirmation or attention.
                            <br />
                            **Please do not reply to this email. For questions or suggestions visit us on our website.
                        </p>
                    </td>
                </tr>"
            // . ($reduce == 1 ? "<a href=\"https://bit.ly/VoteSalkantay2023\">
            //     <img src=\"[[VOTE_FOR_US_FOOTER]]\" style=\"width: 100%; height: auto; \"/>
            // </a>" : '' ) . "
            // "
            . "
        </body>
        </html>
        ";

        return $Body;
    }

    public function Get_H1($Text, $reduce = 1)
    {
        $Content = "
        <h1 style=\"$this->Style_Base padding: $this->Padding; font-family: $this->Font_Family; font-size: " . ($reduce * 22) .
            "px; font-weight: 600; color: $this->Color_Primary; text-align: center;\">
            $Text
        </h1>
        ";

        return $Content;
    }
    public function Get_H2($Text)
    {
        $Content = "
        <h2 style=\"$this->Style_Base padding: $this->Padding; font-family: $this->Font_Family; font-size: 18px; font-weight: 600; color: $this->Color_Primary; text-align: center;\">
            $Text
        </h2>
        ";

        return $Content;
    }
    public function Get_H3($Text)
    {
        $Content = "
        <h3 style=\"$this->Style_Base padding: $this->Padding; font-family: $this->Font_Family; font-size: 16px; font-weight: 600; color: $this->Color_Black_Dark; text-align: left;\">
            $Text
        </h3>
        ";

        return $Content;
    }
    public function Get_H4($Text)
    {
        $Content = "
        <h4 style=\"$this->Style_Base padding: $this->Padding; font-family: $this->Font_Family; font-size: 16px; font-weight: 600; color: $this->Color_Black_Dark; text-align: left;\">
            $Text
        </h4>
        ";

        return $Content;
    }
    public function Get_H4_2($Text)
    {
        $Content = "
        <span style=\"$this->Style_Base_2 padding: $this->Padding; font-family: $this->Font_Family; font-size: 16px; font-weight: 600; color: $this->Color_Black_Dark; text-align: left;\">
            $Text
        </span>
        ";

        return $Content;
    }

    public function align($Align)
    {
        $alignData = [
            "RIGHT" => "right",
            "LEFT" => "left",
            "CENTER" => "center",
            "JUSTIFY" => "justify"
        ];
        return $alignData[$Align] ?? 'left';
    }

    public function Get_P($Text, $Align, $reduce = 1)
    {
        $Content_Align = "text-align: " . $this->align($Align);

        $Content = "
        <p style=\"$this->Style_Base line-height: 1.5; padding: $this->Padding; font-family: $this->Font_Family; font-size: " .
            ($reduce * 13) . "px; color: $this->Color_Black; $Content_Align\">
            $Text
        </p>
        ";

        return $Content;
    }

    public function Get_P_2($Text, $Align, $padding = '5px 20px', $size = 13, $reduce = 1)
    {
        $Content_Align = "text-align: " . $this->align($Align);

        $Content = "
        <p style=\"$this->Style_Base line-height: 1.5; padding: $padding; font-family: $this->Font_Family; font-size: " .
            ($reduce * $size) . "px; color: $this->Color_Black_Dark; $Content_Align\">
            $Text
        </p>
        ";

        return $Content;
    }

    public function Get_H3_2($Text, $Align, $padding = '5px 20px', $reduce = 1)
    {
        $Content_Align = "text-align: " . $this->align($Align);

        $Content = "
        <p style=\"$this->Style_Base line-height: 1.5; padding: $padding; font-family: $this->Font_Family; font-size: " .
            ($reduce * 16) . "px; font-weight: 600; color: $this->Color_Black_Dark; $Content_Align\">
            $Text
        </p>
        ";

        return $Content;
    }

    public function Get_Cell($Text)
    {
        $Content = "
        <td style=\"border: 1px solid black; line-height: 1.5; padding: 5px 10px; font-size: 13px; color: $this->Color_Black_Dark;\">
            $Text
        </td>
        ";

        return $Content;
    }

    public function Get_Head($Text)
    {
        $Content = "
        <th style=\"border: 1px solid black; line-height: 1.5; padding: 5px 10px; font-family: $this->Font_Family; font-size: 16px; color: $this->Color_Black_Dark;\">
            $Text
        </th>
        ";

        return $Content;
    }

    public function Get_Br()
    {
        return '<br />';
    }

    public function Get_Table($heads, $headFunction, $rows, $rowFunction, $colFunction)
    {

        $heads = '<tr >' . implode(
            '',
            array_map(
                function ($head) use ($headFunction) {
                    return $headFunction($head);
                },
                $heads
            )
        ) . '</tr>';

        $rows = implode(
            '',
            array_map(
                function ($row) use ($rowFunction, $colFunction) {
                    return '<tr>' . implode(' ', array_map($colFunction, $rowFunction($row))) . '</tr>';
                },
                $rows
            )
        );

        return "<table style=\"border: 1px solid black; width: 100%; border-collapse: collapse; $this->Style_Base 
                font-family: $this->Font_Family;
                font-size: 16px; font-weight: 600; color: $this->Color_Black_Dark; text-align: left;padding: 0px 40px; display: table; \">$heads $rows</table>";
    }

    public function Get_List($elements, $function)
    {

        $elements = array_map($function, $elements);
        $elements = implode(
            ' ',
            array_map(
                function ($ele) {
                    return "<li style=\"$this->Style_Base list-style:none\">$ele</li>";
                },
                $elements
            )
        );

        $Content = "<ul>$elements</ul>";
        return $Content;
    }
}
