<?php

namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Owner\Group;
use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Modules\GroupPassenger\Application\UpdateReview\UpdateReviewGroupPassengerQuery;
use App\Modules\GroupPassenger\Domain\GroupPassengerReviewDateUpdate;
use App\Modules\GroupPassenger\Domain\GroupPassengerReviewStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Illuminate\Support\Facades\DB;

class c_Passenger_Review extends Controller
{
    private $oDomain;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->oDomain = "Passenger Review";
    }

    public function Update(Request $Request, $passengerReview)
    {
        $oReview        = array();
        $oResponse      = array();
        $oValParams     = [
            'PassengerReview' => 'required|string',
            'Passenger' => 'required|string'
        ];


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oReview    = json_decode($Request->input("PassengerReview"));
            $passenger = json_decode($Request->input("Passenger"));
            if ($passenger->SendPassengerForm) {
                $param = [
                    $passenger->Id_Passenger,
                    $passenger->Passenger_Email,
                    1
                ];
                $oData = DB::select('CALL sp_passenger_update_email(?,?,?)', $param);
            }

            for ($k = 0; $k < count($oReview); $k++) {
                $oParam = [
                    $oReview[$k]->Id_PassengerReview,
                    $oReview[$k]->PassengerReview_Score,
                    $oReview[$k]->PassengerReview_Comment,
                    $oReview[$k]->PassengerReview_Values
                ];
                $oData  = DB::select('call sp_client_passenger_review_update(?,?,?,?)', $oParam);

                if ($k == 0) {
                    $passReview = DB::select('call sp_passenger_review_index(?)', [$oReview[$k]->Id_PassengerReview]);
                    if (count($passReview)) {
                        $this->queryBus->ask(new UpdateReviewGroupPassengerQuery(
                            $passReview[0]->Id_GroupPassenger,
                            GroupPassengerReviewStatus::ANSWERED
                        ));
                    }
                    $this->sendMail($oReview[$k]);
                }
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    private function sendMail($review)
    {
        try {
            $passReview = DB::select('call sp_passenger_review_index(?)', [$review->Id_PassengerReview]);
            if (!count($passReview)) {
                return;
            }

            Group::sendPassengerReviewMail($passReview[0]->Id_Passenger, $this->oDomain);
        } catch (\Throwable $ex) {
        }
    }

    public function List(Request $Request, $Token)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Token($Token, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array($Token);
            $oData  = DB::select('call sp_client_passenger_review_list(?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " List";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
}
