<?php

namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Modules\Credential\Domain\Credential;
use App\Modules\Package\Application\GetCampSchedule\GetPackageCampScheduleQuery;
use App\Modules\Package\Application\PackageDaysGenerator;
use App\Modules\Package\Application\PackageDaysGeneratorWithDay;
use App\Modules\Package\Infraestructure\PackageValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Support\Facades\DB;

class Package extends Controller
{
    private $oDomain;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->oDomain = "Package";
    }

    public function calendarDays(Request $request)
    {
        $response = ParamsValidator::Validate_Request($request, [
            'Id_Package' => 'required|string|max:20',
            'Month' => 'required|int',
            'Year' => 'required|int'
        ], $this->oDomain);

        if ($response["Response_Code"] != 200) {
            return ResponseBuilder::Response($response);
        }

        $tours = DB::select('call sp_package_tour_list(?)', [$request->input('Id_Package')]);
        $oData = (new PackageDaysGenerator)->__invoke(
            $request->input('Year'),
            $request->input('Month'),
            $tours
        );

        $response["Response_Status"]           = 200;
        $response["Response_Code"]             = 200;
        $response["Response_Domain"]           = $this->oDomain;
        $response["Response_Message"]          = $this->oDomain . " Index ";
        $response["Response_Data"]             = $oData;
        $response["Response_Error_Message"]    = "";
        $response["Response_Error_Reason"]     = "";

        return ResponseBuilder::Response($response);
    }

    public function Index(Request $Request)
    {
        $oResponse  = array();
        $oValParams     = array(
            'Package_Code'          => 'required|string|max:50',
            'Language_Code'         => 'required|string|max:2'
        );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam     = array(
                $Request->input("Package_Code"),
                $Request->input("Language_Code")
            );
            $oData  = DB::select('call sp_client_package_index(?,?)', $oParam);

            if (isset($oData[0]->Id_Package)) {

                $oParam     = array(
                    $oData[0]->Id_Package,
                    $oData[0]->Id_Language
                );

                $oDataRate  = DB::select('call sp_client_package_rate_list(?,?)', $oParam);

                $oParam     = array(
                    $oData[0]->Id_Package,
                    $oData[0]->Id_Language
                );
                $oDataTour  = DB::select('call sp_client_tour_index(?,?)', $oParam);

                if (isset($oDataTour[0]->Id_Tour)) {
                    for ($j = 0; $j < count($oDataTour); $j++) {
                        $oParam     = array(
                            $oDataTour[$j]->Id_Tour,
                            $oData[0]->Id_Language
                        );

                        $oDataTypeUpgrade  = DB::select('call sp_client_tour_upgrade_type_list(?,?,2)', $oParam);

                        if (isset($oDataTypeUpgrade[0]->Id_TourUpgradeType)) {

                            for ($k = 0; $k < count($oDataTypeUpgrade); $k++) {
                                $oParam     = array(
                                    $oDataTypeUpgrade[$k]->Id_TourUpgradeType,
                                    $oData[0]->Id_Language
                                );

                                $oDataUpgrade  = DB::select('call sp_client_tour_upgrade_list(?,?)', $oParam);
                                $oDataTypeUpgrade[$k]->Upgrade           = $oDataUpgrade;
                            }
                        }

                        $oParam     = array(
                            $oDataTour[$j]->Id_Tour,
                            $oData[0]->Id_Language
                        );

                        $oDataTypeEquipment  = DB::select('call sp_client_tour_equipment_type_list(?,?,2)', $oParam);

                        if (isset($oDataTypeEquipment[0]->Id_TourEquipmentType)) {
                            for ($k = 0; $k < count($oDataTypeEquipment); $k++) {
                                $oParam     = array(
                                    $oDataTypeEquipment[$k]->Id_TourEquipmentType,
                                    $oData[0]->Id_Language
                                );

                                $oDataEquipment  = DB::select('call sp_client_tour_equipment_list(?,?)', $oParam);
                                $oDataTypeEquipment[$k]->Equipment           = $oDataEquipment;
                                if (isset($oDataEquipment[0]->Id_Equipment)) {
                                    for ($l = 0; $l < count($oDataEquipment); $l++) {
                                        $oParam     = array($oDataEquipment[$l]->Id_Equipment);

                                        $oDataEquipmentRate  = DB::select('call sp_equipment_rate_list(?)', $oParam);

                                        $oDataEquipment[$l]->Rate               = $oDataEquipmentRate;
                                    }
                                }
                            }
                        }

                        $oParam     = array(
                            $oDataTour[$j]->Id_Tour,
                            $oData[0]->Id_Language
                        );

                        $oDataTypeExtra  = DB::select('call sp_client_tour_extra_type_list(?,?,2)', $oParam);

                        if (isset($oDataTypeExtra[0]->Id_TourExtraType)) {
                            for ($k = 0; $k < count($oDataTypeExtra); $k++) {
                                $oParam     = array(
                                    $oDataTypeExtra[$k]->Id_TourExtraType,
                                    $oData[0]->Id_Language
                                );

                                $oDataExtra  = DB::select('call sp_client_tour_extra_list(?,?)', $oParam);
                                $oDataTypeExtra[$k]->Extra           = $oDataExtra;
                            }
                        }

                        $oDataTour[$j]->Type_Upgrade                 = $oDataTypeUpgrade;
                        $oDataTour[$j]->Type_Equipment               = $oDataTypeEquipment;
                        $oDataTour[$j]->Type_Extra                   = $oDataTypeExtra;
                    }
                }

                $Path_Thumb     = config("var.PATH_PUBLIC") . config("var.USER_COUNTRY_THUMB");
                $oParam = array($Path_Thumb);

                $oDataCountry  = DB::select('call sp_client_user_country_list(?)', $oParam);

                $oParam     = array($oData[0]->Id_Language);

                $oDataDoc  = DB::select('call sp_client_type_document_list(?)', $oParam);

                $oParam     = array($oData[0]->Id_Package);

                $oDataFees  = DB::select('call sp_package_fee_list(?)', $oParam);

                $oData[0]->Tours                           = $oDataTour;
                $oData[0]->Rate                            = $oDataRate;
                $oData[0]->Type_Document                   = $oDataDoc;
                $oData[0]->Country                         = $oDataCountry;
                $oData[0]->Fees                            = $oDataFees;
            }



            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " Index ";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function IndexClient(Request $Request)
    {
        $oResponse  = array();
        $oValParams     = array(
            'Id_Package' => 'required|int',
            'Id_Language' => 'required|int'
        );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam     = array(
                $Request->input("Id_Package"),
                $Request->input("Id_Language")
            );
            $oData  = DB::select('call sp_client_package_index_client(?,?)', $oParam);


            if (isset($oData[0]->Id_Package)) {

                $oParam     = array(
                    $oData[0]->Id_Package,
                    $oData[0]->Id_Language
                );

                $oDataRate  = DB::select('call sp_client_package_rate_list(?,?)', $oParam);

                $oParam     = array(
                    $oData[0]->Id_Package,
                    $oData[0]->Id_Language
                );
                $oDataTour  = DB::select('call sp_client_tour_index(?,?)', $oParam);

                if (isset($oDataTour[0]->Id_Tour)) {
                    for ($j = 0; $j < count($oDataTour); $j++) {
                        $oParam     = array(
                            $oDataTour[$j]->Id_Tour,
                            $oData[0]->Id_Language
                        );

                        $oDataTypeUpgrade  = DB::select('call sp_client_tour_upgrade_type_list(?,?,2)', $oParam);

                        if (isset($oDataTypeUpgrade[0]->Id_TourUpgradeType)) {

                            for ($k = 0; $k < count($oDataTypeUpgrade); $k++) {
                                $oParam     = array(
                                    $oDataTypeUpgrade[$k]->Id_TourUpgradeType,
                                    $oData[0]->Id_Language
                                );

                                $oDataUpgrade  = DB::select('call sp_client_tour_upgrade_list(?,?)', $oParam);
                                $oDataTypeUpgrade[$k]->Upgrade           = $oDataUpgrade;
                            }
                        }


                        $oParam     = array(
                            $oDataTour[$j]->Id_Tour,
                            $oData[0]->Id_Language
                        );

                        $oDataTypeEquipment  = DB::select('call sp_client_tour_equipment_type_list(?,?,2)', $oParam);

                        if (isset($oDataTypeEquipment[0]->Id_TourEquipmentType)) {
                            for ($k = 0; $k < count($oDataTypeEquipment); $k++) {
                                $oParam     = array(
                                    $oDataTypeEquipment[$k]->Id_TourEquipmentType,
                                    $oData[0]->Id_Language
                                );

                                $oDataEquipment  = DB::select('call sp_client_tour_equipment_list(?,?)', $oParam);
                                $oDataTypeEquipment[$k]->Equipment           = $oDataEquipment;
                                if (isset($oDataEquipment[0]->Id_Equipment)) {
                                    for ($l = 0; $l < count($oDataEquipment); $l++) {
                                        $oParam     = array($oDataEquipment[$l]->Id_Equipment);

                                        $oDataEquipmentRate  = DB::select('call sp_equipment_rate_list(?)', $oParam);

                                        $oDataEquipment[$l]->Rate               = $oDataEquipmentRate;
                                    }
                                }
                            }
                        }

                        $oParam     = array(
                            $oDataTour[$j]->Id_Tour,
                            $oData[0]->Id_Language
                        );

                        $oDataTypeExtra  = DB::select('call sp_client_tour_extra_type_list(?,?,2)', $oParam);

                        if (isset($oDataTypeExtra[0]->Id_TourExtraType)) {
                            for ($k = 0; $k < count($oDataTypeExtra); $k++) {
                                $oParam     = array(
                                    $oDataTypeExtra[$k]->Id_TourExtraType,
                                    $oData[0]->Id_Language
                                );

                                $oDataExtra  = DB::select('call sp_client_tour_extra_list(?,?)', $oParam);
                                $oDataTypeExtra[$k]->Extra           = $oDataExtra;
                            }
                        }

                        $oDataTour[$j]->Type_Upgrade                 = $oDataTypeUpgrade;
                        $oDataTour[$j]->Type_Equipment               = $oDataTypeEquipment;
                        $oDataTour[$j]->Type_Extra                   = $oDataTypeExtra;
                    }
                }

                $Path_Thumb     = config("var.PATH_PUBLIC") . config("var.USER_COUNTRY_THUMB");
                $oParam = array($Path_Thumb);

                $oDataCountry  = DB::select('call sp_client_user_country_list(?)', $oParam);

                $oParam     = array($oData[0]->Id_Language);

                $oDataDoc  = DB::select('call sp_client_type_document_list(?)', $oParam);

                $oParam     = array($oData[0]->Id_Package);

                $oDataFees  = DB::select('call sp_package_fee_list(?)', $oParam);

                $oData[0]->Tours                           = $oDataTour;
                $oData[0]->Rate                            = $oDataRate;
                $oData[0]->Type_Document                   = $oDataDoc;
                $oData[0]->Country                         = $oDataCountry;
                $oData[0]->Fees                            = $oDataFees;
            }



            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " Index ";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function IndexById(Request $Request)
    {
        $oResponse = array();
        (new LaravelValidator())->validate($Request->all(), $this->oDomain, PackageValidators::INDEX_BY_ID);

        //  INGRESANDO DATOS
        $oParam     = array(
            $Request->input("Id_Package"),
            $Request->input("Id_Language")
        );
        $oData  = DB::select('call sp_client_package_index_by_id(?,?)', $oParam);


        if (isset($oData[0]->Id_Package)) {

            $oParam     = array(
                $oData[0]->Id_Package,
                $oData[0]->Id_Language
            );

            $oDataRate  = DB::select('call sp_client_package_rate_list(?,?)', $oParam);

            $oParam     = array(
                $oData[0]->Id_Package,
                $oData[0]->Id_Language
            );
            $oDataTour  = DB::select('call sp_client_tour_index(?,?)', $oParam);

            for ($j = 0; $j < count($oDataTour); $j++) {
                $oParam = array(
                    $oDataTour[$j]->Id_Tour,
                    $oData[0]->Id_Language
                );

                $oDataTypeUpgrade  = DB::select('call sp_client_tour_upgrade_type_list(?,?,2)', $oParam);

                for ($k = 0; $k < count($oDataTypeUpgrade); $k++) {
                    $oParam     = array(
                        $oDataTypeUpgrade[$k]->Id_TourUpgradeType,
                        $oData[0]->Id_Language
                    );

                    $oDataUpgrade  = DB::select('call sp_client_tour_upgrade_list(?,?)', $oParam);
                    $oDataTypeUpgrade[$k]->Upgrade           = $oDataUpgrade;
                }

                $oParam     = array(
                    $oDataTour[$j]->Id_Tour,
                    $oData[0]->Id_Language
                );

                $oDataTypeEquipment  = DB::select('call sp_client_tour_equipment_type_list(?,?,2)', $oParam);

                for ($k = 0; $k < count($oDataTypeEquipment); $k++) {
                    $oParam     = array(
                        $oDataTypeEquipment[$k]->Id_TourEquipmentType,
                        $oData[0]->Id_Language
                    );

                    $oDataEquipment  = DB::select('call sp_client_tour_equipment_list(?,?)', $oParam);
                    $oDataTypeEquipment[$k]->Equipment           = $oDataEquipment;
                    if (isset($oDataEquipment[0]->Id_Equipment)) {
                        for ($l = 0; $l < count($oDataEquipment); $l++) {
                            $oParam     = array($oDataEquipment[$l]->Id_Equipment);
                            $oDataEquipmentRate  = DB::select('call sp_equipment_rate_list(?)', $oParam);
                            $oDataEquipment[$l]->Rate               = $oDataEquipmentRate;
                        }
                    }
                }

                $oParam     = array(
                    $oDataTour[$j]->Id_Tour,
                    $oData[0]->Id_Language
                );

                $oDataTypeExtra  = DB::select('call sp_client_tour_extra_type_list(?,?,2)', $oParam);

                if (isset($oDataTypeExtra[0]->Id_TourExtraType)) {
                    for ($k = 0; $k < count($oDataTypeExtra); $k++) {
                        $oParam     = array(
                            $oDataTypeExtra[$k]->Id_TourExtraType,
                            $oData[0]->Id_Language
                        );

                        $oDataExtra  = DB::select('call sp_client_tour_extra_list(?,?)', $oParam);
                        $oDataTypeExtra[$k]->Extra           = $oDataExtra;
                    }
                }

                $oDataTour[$j]->Type_Upgrade                 = $oDataTypeUpgrade;
                $oDataTour[$j]->Type_Equipment               = $oDataTypeEquipment;
                $oDataTour[$j]->Type_Extra                   = $oDataTypeExtra;
            }

            $months = $Request->input('Months');
            $oMonthsData = [];
            foreach ($months as $monthValue) {
                // $oMonthsData[] = (new PackageDaysGenerator)->__invoke($monthValue['Year'], $monthValue['Month'], $oDataTour);
                $oMonthsData[] = (new PackageDaysGeneratorWithDay)->__invoke($monthValue['Year'], $monthValue['Month'], $oDataTour);
            }

            $oParam     = array($oData[0]->Id_Package);

            $credentials = DB::select('CALL sp_credential_list()');
            $oDataFees  = DB::select('call sp_package_fee_list(?)', $oParam);

            $oData[0]->Credentials  = Credential::getPublic($credentials);
            $oData[0]->Tours        = $oDataTour;
            $oData[0]->LockDays     = $oMonthsData;
            $oData[0]->Rate         = $oDataRate;
            $oData[0]->Fees         = $oDataFees;
        }

        $oResponse["Response_Status"]           = 200;
        $oResponse["Response_Code"]             = 200;
        $oResponse["Response_Domain"]           = $this->oDomain;
        $oResponse["Response_Message"]          = $this->oDomain . " Index ";
        $oResponse["Response_Data"]             = $oData;
        $oResponse["Response_Error_Message"]    = "";
        $oResponse["Response_Error_Reason"]     = "";

        return ResponseBuilder::Response($oResponse);
    }

    public function ListBooking(Request $Request)
    {
        $oResponse  = array();
        $Id = 'active';

        $oResponse = ParamsValidator::Validate_Action($Id, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oParam = array($Id);
            $oData  = $this->getEndorserPackages(DB::select('call sp_package_list(?)', $oParam));

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " list " . $Id;
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    private function getEndorserPackages($packageList)
    {
        return array_values(array_filter($packageList, function ($package) {
            return $package->Package_Endorser == '2';
        }));
    }

    public function IndexBooking(Request $Request)
    {
        $oResponse  = array();
        $oValParams     = array(
            'Id_Package'            => 'required|string|max:20',
            'Id_Language'           => 'required|string|max:2'
        );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {

            $oData = DB::select('call sp_client_user_session_index(?)', [$Request->header("Token")]);

            if ($oData[0]->Response_Code == 200) {

                $oData = array_map(
                    function ($p) use ($oData) {

                        $p->UserPackageRate = DB::select('CALL sp_user_package_package_rate_list(?,?)', [$oData[0]->Response_Id_User, $p->Id_Package]);
                        $p->Rate = DB::select('call sp_client_package_rate_list(?,?)', [$p->Id_Package, $p->Id_Language]);
                        $p->Type_Document = DB::select('call sp_client_type_document_list(?)', [$p->Id_Language]);
                        $Path_Thumb     = config("var.PATH_PUBLIC") . config("var.USER_COUNTRY_THUMB");
                        $p->Country = DB::select('call sp_client_user_country_list(?)', [$Path_Thumb]);

                        $p->Tours = array_map(
                            function ($t) use ($p) {

                                $t->Type_Upgrade = array_map(
                                    function ($type) use ($p) {
                                        $type->Upgrade = DB::select('call sp_tour_upgrade_booking(?,?)', [
                                            $type->Id_TourUpgradeType,
                                            $p->Id_Language
                                        ]);
                                        return $type;
                                    },
                                    DB::select('call sp_client_tour_upgrade_type_list(?,?,1)', [$t->Id_Tour, $p->Id_Language])
                                );

                                $t->Type_Equipment = array_map(
                                    function ($type) use ($p) {
                                        $type->Equipment = array_map(
                                            function ($equipment) {
                                                $equipment->Rate = DB::select('call sp_equipment_rate_list(?)', [$equipment->Id_Equipment]);
                                                return $equipment;
                                            },
                                            DB::select('call sp_tour_equipment_booking(?,?)', [
                                                $type->Id_TourEquipmentType,
                                                $p->Id_Language
                                            ])
                                        );
                                        return $type;
                                    },
                                    DB::select('call sp_client_tour_equipment_type_list(?,?,1)', [$t->Id_Tour, $p->Id_Language])
                                );

                                $t->Type_Extra = array_map(
                                    function ($type) use ($p) {
                                        $type->Extra = DB::select('call sp_tour_extra_booking(?,?)', [
                                            $type->Id_TourExtraType,
                                            $p->Id_Language
                                        ]);
                                        return $type;
                                    },
                                    DB::select('call sp_client_tour_extra_type_list(?,?,1)', [$t->Id_Tour, $p->Id_Language])
                                );
                                $t->PackageTourEquipment = DB::select('call sp_package_tour_equipment_list(?)', [$t->Id_PackageTour]);
                                $t->PackageTourExtra = DB::select('call sp_package_tour_extra_list(?)', [$t->Id_PackageTour]);
                                $t->PackageTourUpgrade = DB::select('call sp_package_tour_upgrade_list(?)', [$t->Id_PackageTour]);
                                return $t;
                            },
                            DB::select('call sp_tour_booking(?,?)', [$p->Id_Package, $p->Id_Language])
                        );
                        return $p;
                    },
                    DB::select('call sp_package_booking_index(?,?)', [
                        $Request->input("Id_Package"),
                        $Request->input("Id_Language")
                    ])
                );
            }



            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " Index ";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
}
