<?php

namespace App\DBTestSupport;

use Illuminate\Support\Facades\DB;

class PackageRateMother {
    
    public static function buildShared1($id = 1, $idPackage = 1, $idTypeRate = 1, $price = '150.00') {
        return [
            'Id_PackageRate' => $id,
            'PackageRate_PaxStart' => 1,
            'PackageRate_PaxEnd' => 10,
            'PackageRate_Price' => $price,
            'PackageRate_PriceConfidential' => $price,
            'PackageRate_Type' => 1,
            'PackageRate_Status' => 2,
            'Id_Package' => $idPackage,
            'Id_TypeRate' => $idTypeRate
        ];
    }

    public static function pushShared1($id = 1, $idPackage = 1, $idTypeRate = 1, $price = '150.00') {
        return self::push(self::buildShared1($id, $idPackage, $idTypeRate, $price));
    }

    private static function push($object) {
        $result = DB::select("CALL `sp_package_rate_insert` (?,?,?,?,?,?,?,?)", [
            $object['PackageRate_PaxStart'],
            $object['PackageRate_PaxEnd'],
            $object['PackageRate_Price'],
            $object['PackageRate_PriceConfidential'],
            $object['PackageRate_Type'],
            $object['PackageRate_Status'],
            $object['Id_Package'],
            $object['Id_TypeRate']
        ]);
        return $object;
    }

}