<?php

namespace App\DBTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;

class LanguageMother {
    
    public static function build1($id = 1) {
        return [
            'Id_Language' => $id,
            'Language_Code' => 'EN',
            'Language_Name' => 'English',
            'Language_Content' => 2,
            'Language_Status' => 2
        ];
    }

    public static function buildBasicLanguage($id = 1) {
        $faker = Factory::create();
        return [
            'Id_Language'       => $id,
            'Language_Code'     => Util::generateString(2),
            'Language_Name'     => $faker->text(rand(5, 250)),
            'Language_Content'  => $faker->randomElement(1, 2),
            'Language_Status'     => $faker->randomElement(1, 2),
        ];
    }

    public static function push1($id = 1) {
        return self::push(self::build1($id));
    }

    public static function pushBasic($id = 1) {
        return self::push(self::build1($id));
    }

    private static function push($object) {
        DB::select("CALL `sp_language_insert` (?,?,?,?)", [
            $object['Language_Code'],
            $object['Language_Name'],
            $object['Language_Content'],
            $object['Language_Status']
        ]);
        return $object;
    }

}