<?php

namespace App\DBRealTestSupport;

use Illuminate\Support\Facades\DB;

class UpgradeTranslMother {
    
    public static function build1($idUpgrade = null, $idLanguage = null, $id = 0) {
        $faker = \Faker\Factory::create();
        $idUpgrade = $idUpgrade ?? UpgradeMother::push1()['Id_Upgrade'];
        $idLanguage = $idLanguage ?? LanguageMother::push1()['Id_Language'];
        return [
            'Id_Upgrade'              => $id,
            'UpgradeTransl_Title'     => $faker->text(rand(5, 250)),
            'Id_Upgrade'              => $idUpgrade,
            'Id_Language'               => $idLanguage,
        ];
    }

    public static function push1($idUpgrade = null, $idLanguage = null, $id = 0) {
        return self::push(self::build1($idUpgrade, $idLanguage, $id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_upgrade_transl_insert` (?,?,?,?)", [
            $object['UpgradeTransl_Title'],
            $object['Id_Upgrade'],
            $object['Id_Language'],
            1
        ]);
        $object['Id_UpgradeTransl'] = $response[0]->Response_Id;
        return $object;
    }

}