<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class TypeBookingAssignMother
{

    public static function build1($id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_TypeBookingAssign'            => $id,
            'TypeBookingAssign_Name'          => $faker->text(rand(5, 250)),
            'TypeBookingAssign_Abrv'          => $faker->text(rand(5, 10)),
            'TypeBookingAssign_Score'         => rand(1, 15),
            'TypeBookingAssign_Status'        => $faker->randomElement([1, 2]),
        ];
    }

    public static function push1($id = 1)
    {
        return self::push(self::build1($id));
    }

    public static function pushBrute1($id = 1)
    {
        return self::pushBrute(self::build1($id));
    }

    private static function pushBrute($object)
    {
        DB::select('INSERT INTO `t_type_booking_assign` (
            `Id_TypeBookingAssign`,
            `TypeBookingAssign_Name`,
            `TypeBookingAssign_Abrv`,
            `TypeBookingAssign_Score`,
            `TypeBookingAssign_Status`
        ) VALUES (?,?,?,?,?)', [
            $object['Id_TypeBookingAssign'],
            $object['TypeBookingAssign_Name'],
            $object['TypeBookingAssign_Abrv'],
            $object['TypeBookingAssign_Score'],
            $object['TypeBookingAssign_Status'],
        ]);
        $response = DB::select('SELECT LAST_INSERT_ID() AS `Id`');
        $object['Id_TypeBookingAssign'] = $response[0]->Id;
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_type_booking_assign_insert` (?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['TypeBookingAssign_Name'],
            $object['TypeBookingAssign_Abrv'],
            $object['TypeBookingAssign_Score'],
            $object['TypeBookingAssign_Status'],
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_TypeBookingAssign'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return [TC::TYPE_BOOKING_ASSIGN];
    }
}
