<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TourQuestionMother
{
    
    public static function build1($idTour, $idQuestion, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_TourQuestion'   => $id,
            'Id_Tour'           => $idTour,
            'Id_Question'       => $idQuestion,
        ];
    }

    public static function push1($idTour, $idQuestion, $id = 1)
    {
        return self::push(self::build1($idTour, $idQuestion, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_tour_question_insert` (?,?)", [
            $object['Id_Tour'],
            $object['Id_Question']
        ]);
        $object['Id_TourQuestion'] = $response[0]->Response_Id;
        return $object;
    }
}
