<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class HtlRoomMother
{

    public static function build1($idHtlTypeRoom = null, $idHtlCamp = null, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_HtlRoom'            => $id,
            'HtlRoom_Number'        => Str::title($faker->text(rand(5, 250))),
            'HtlRoom_Availability'  => rand(0, 5000),
            'HtlRoom_Status'        => $faker->randomElement([1, 2]),
            'Id_HtlTypeRoom'        => $idHtlTypeRoom ?? HtlTypeRoomMother::push1()['Id_HtlTypeRoom'],
            'Id_HtlCamp'            => $idHtlCamp
        ];
    }

    public static function push1($idHtlTypeRoom = null, $idHtlCamp = null, $id = 1)
    {
        return self::push(self::build1($idHtlTypeRoom, $idHtlCamp, $id));
    }

    private static function push($object)
    {
        DB::select("CALL `sp_htl_room_insert`(?,?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['HtlRoom_Number'],
            $object['HtlRoom_Availability'],
            $object['HtlRoom_Status'],
            $object['Id_HtlTypeRoom'],
            $object['Id_HtlCamp'],
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_HtlRoom'] = $response[0]->{'@id'};
        }
        return $object;
    }
}
