<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\DBRealTestSupport\TableCreation as TC;

class HtlCampScheduleMother
{

    public static function build1($idHtlCamp = null, $id = 0)
    {
        $faker = Factory::create();
        $idHtlCamp = $idHtlCamp ?? HtlCampMother::push1()['Id_HtlCamp'];
        return [
            'Id_HtlCampSchedule'            => $id,
            'HtlCampSchedule_Date'          => date('Y-m-d H:i:s'),
            'HtlCampSchedule_DateSchedule'  => date('Y-m-d 00:00:00', strtotime('+' . rand(1, 30) . ' days')),
            'HtlCampSchedule_FromCamp'      => $faker->randomElement([1, 2]),
            'HtlCampSchedule_Availability'  => rand(5, 1000),
            'HtlCampSchedule_AmountUsage'   => rand(5, 1000),
            'HtlCampSchedule_Lock'          => $faker->randomElement([1, 2]),
            'Id_HtlCamp'                    => $idHtlCamp
        ];
    }

    public static function push1($idHtlCamp = null, $id = 0)
    {
        return self::push(self::build1($idHtlCamp, $id));
    }

    public static function push($object)
    {
        DB::select("INSERT INTO " . TC::HTL_CAMP_SCHEDULE . " (
            `Id_HtlCampSchedule`,
            `HtlCampSchedule_Date`,
            `HtlCampSchedule_DateSchedule`,
            `HtlCampSchedule_FromCamp`,
            `HtlCampSchedule_Availability`,
            `HtlCampSchedule_AmountUsage`,
            `HtlCampSchedule_Lock`,
            `Id_HtlCamp`
        ) VALUES (?,?,?,?,?,?,?,?)", [
            $object['Id_HtlCampSchedule'] === 0 ? null : $object['Id_HtlCampSchedule'],
            $object['HtlCampSchedule_Date'],
            $object['HtlCampSchedule_DateSchedule'],
            $object['HtlCampSchedule_FromCamp'],
            $object['HtlCampSchedule_Availability'],
            $object['HtlCampSchedule_AmountUsage'],
            $object['HtlCampSchedule_Lock'],
            $object['Id_HtlCamp'],
        ]);
        $response = DB::select('SELECT LAST_INSERT_ID() as Id');
        $object['Id_HtlCampSchedule'] = $response[0]->Id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [ TC::HTL_CAMP_SCHEDULE ];
    }
}
