<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class HtlCampBookingPassengerMother
{

    public static function build1($idHtlCampBooking = null, $idBookingTourPassenger = null, $id = 0)
    {
        $faker = Factory::create();
        $idHtlCampBooking = $idHtlCampBooking ?? HtlCampBookingMother::push1()['Id_HtlCampBooking'];
        return [
            'Id_HtlCampBookingPassenger'        => $id,
            'HtlCampBookingPassenger_Weight'    => rand(1, 12),
            'HtlCampBookingPassenger_Status'    => $faker->randomElement([1, 2]),
            'Id_HtlCampBooking'                 => $idHtlCampBooking,
            'Id_BookingTourPassenger'           => $idBookingTourPassenger
        ];
    }

    public static function push1($idHtlCampBooking = null, $idBookingTourPassenger = null, $id = 0)
    {
        return self::push(self::build1($idHtlCampBooking, $idBookingTourPassenger, $id));
    }

    private static function push($object)
    {
        DB::select("INSERT INTO " . TC::HTL_CAMP_BOOKING_PASSENGER . " (
            `Id_HtlCampBookingPassenger`,
            `HtlCampBookingPassenger_Weight`,
            `HtlCampBookingPassenger_Status`,
            `Id_HtlCampBooking`,
            `Id_BookingTourPassenger`
        ) VALUES (?,?,?,?,?)", [
            $object['Id_HtlCampBookingPassenger'] === 0 ? null : $object['Id_HtlCampBookingPassenger'],
            $object['HtlCampBookingPassenger_Weight'],
            $object['HtlCampBookingPassenger_Status'],
            $object['Id_HtlCampBooking'],
            $object['Id_BookingTourPassenger']
        ]);
        $response = DB::select('SELECT LAST_INSERT_ID() as Id');
        $object['Id_HtlCampBookingPassenger'] = $response[0]->Id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [TC::HTL_CAMP_BOOKING_PASSENGER, ...HtlCampBookingMother::tablesToClear()];
    }
}
