<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;

class GroupMother
{

    public const SERVICE_REGULAR = 1;
    public const SERVICE_ALCANCE = 2;
    public const SERVICE_TRANSFERIN = 3;
    public const SERVICE_TRANSFEROUT = 4;

    public const MASTER_INDEPENDENT = 1;
    public const MASTER_SLAVE = 2;
    public const MASTER_MASTER = 3;

    public static function build1($masterType, $idMaster, $serviceType, $idService, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_Group' => $id,
            'Group_Date' => date('Y-m-d H:i:s', strtotime("-5 hour")),
            'Group_DateUpdate' => date('Y-m-d H:i:s', strtotime("-5 hour")),
            'Group_DateStart' => date('Y-m-d'),
            'Group_DateEnd' => date('Y-m-d'),
            'Group_Hour' => date('H:i:s'),
            'Group_Name' => '',
            'Group_Origin' => '',
            'Group_Destination' => '',
            'Group_Type' => $faker->randomElement([1, 2]),
            'Group_TourDuration' => 1,
            'Group_Remark' => $faker->text(rand(5, 500)),
            'Group_MasterType' => $masterType,
            'Group_ServiceType' => $serviceType,
            'Group_Status' => $faker->randomElement([1, 2]),
            'Id_Master' => $idMaster,
            'Id_Service' => $idService
        ];
    }

    public static function push1($masterType, $idMaster, $serviceType, $idService, $id = 1)
    {
        return self::push(
            self::build1(
                $masterType,
                $idMaster,
                $serviceType,
                $idService,
                $id
            )
        );
    }

    public static function generateGroup($idTour)
    {
        return GroupMother::push1(
            GroupMother::MASTER_INDEPENDENT,
            0,
            GroupMother::SERVICE_REGULAR,
            $idTour
        );
    }

    public static function push($object)
    {
        $response = DB::select(
            "CALL `sp_group_insert` (?,?,?,?,?,?,?,?)",
            [
                $object['Group_DateStart'],
                $object['Group_Hour'],
                $object['Group_Origin'],
                $object['Group_Destination'],
                $object['Group_Type'],
                $object['Group_Remark'],
                $object['Group_ServiceType'],
                $object['Id_Service'],
            ]
        );
        $object['Id_Group'] = $response[0]->Response_Id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [
            TableCreation::group,
        ];
    }
}
