<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;
use App\Modules\FactTypeOperation\Domain\IdFactTypeOperation;

class FactTypeOperationMother
{

    public static function pushDefault()
    {
        return self::push(self::build1(IdFactTypeOperation::defaultValue()));
    }
    
    public static function build1($id = 0)
    {
        $faker = Factory::create();
        return [
            'Id_FactTypeOperation' => $id,
            'FactTypeOperation_Name' => $faker->text(rand(5, 100)),
            'FactTypeOperation_Abrv' => Util::generateString(10),
            'FactTypeOperation_Status' => $faker->randomElement([1, 2])
        ];
    }

    public static function push1($id = 0)
    {
        return self::push(self::build1($id));
    }

    private static function push($object)
    {
        $response = DB::select("INSERT INTO `t_fact_type_operation`(`Id_FactTypeOperation`, `FactTypeOperation_Name`, `FactTypeOperation_Abrv`, `FactTypeOperation_Status`)
            VALUES (?,?,?,?)", [
            $object['Id_FactTypeOperation'] == 0 ? null : $object['Id_FactTypeOperation'],
            $object['FactTypeOperation_Name'],
            $object['FactTypeOperation_Abrv'],
            $object['FactTypeOperation_Status'],
        ]);
        $response = DB::select('SELECT LAST_INSERT_ID() as `id`');
        $object['Id_FactTypeOperation'] = $response[0]->id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [ TC::FACT_TYPE_OPERATION ];
    }
}
