<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;

class FactProductMother
{
    
    public static function build1($id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_FactProduct' => $id,
            'FactProduct_Code' => Util::generateString(10),
            'FactProduct_Name' => $faker->text(rand(5, 100)),
            'FactProduct_IdProduct' => $faker->text(rand(5, 100)),
            'FactProduct_Status' => $faker->randomElement([1, 2]),
        ];
    }

    public static function push1($id = 1)
    {
        return self::push(self::build1($id));
    }

    private static function push($object)
    {
        $response = DB::select("INSERT INTO `t_fact_product`(`FactProduct_Code`, `FactProduct_Name`, `FactProduct_IdProduct`, `FactProduct_Status`)
            VALUES (?,?,?,?)", [
            $object['FactProduct_Code'],
            $object['FactProduct_Name'],
            $object['FactProduct_IdProduct'],
            $object['FactProduct_Status'],
        ]);
        $response = DB::select('SELECT LAST_INSERT_ID() as `id`');
        $object['Id_FactProduct'] = $response[0]->id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [ TableCreation::FACT_PRODUCT, ...FactUnitMother::tablesToClear() ];
    }
}
