<?php

namespace App\DBRealTestSupport;

use Illuminate\Support\Facades\DB;

class EquipmentTranslMother {
    
    public static function build1($idEquipment = null, $idLanguage = null, $id = 0) {
        $faker = \Faker\Factory::create();
        $idEquipment = $idEquipment ?? EquipmentMother::push1()['Id_Equipment'];
        $idLanguage = $idLanguage ?? LanguageMother::push1()['Id_Language'];
        return [
            'Id_Equipment'              => $id,
            'EquipmentTransl_Title'     => $faker->text(rand(5, 250)),
            'Id_Equipment'              => $idEquipment,
            'Id_Language'               => $idLanguage,
        ];
    }

    public static function push1($idEquipment = null, $idLanguage = null, $id = 0) {
        return self::push(self::build1($idEquipment, $idLanguage, $id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_equipment_transl_insert` (?,?,?,?)", [
            $object['EquipmentTransl_Title'],
            $object['Id_Equipment'],
            $object['Id_Language'],
            1
        ]);
        $object['Id_EquipmentTransl'] = $response[0]->Response_Id;
        return $object;
    }

}