<?php

namespace App\DBRealTestSupport;

use Illuminate\Support\Facades\DB;

class EquipmentMother {
    
    public static function build1($idItem = null, $idTypeEquipment = null, $id = 0) {
        $faker = \Faker\Factory::create();
        return [
            'Id_Equipment'      => $id,
            'Equipment_Code'    => $faker->text(rand(5, 10)),
            'Equipment_ShowOnBookingTour' => $faker->randomElement([1, 2]),
            'Equipment_Status'  => $faker->randomElement([1, 2]),
            'Id_Item'           => $idItem ?? ItemMother::push1()['Id_Item'],
            'Id_TypeEquipment'  => $idTypeEquipment ?? TypeEquipmentMother::push1()['Id_TypeEquipment']
        ];
    }

    public static function push1($idItem = null, $idTypeEquipment = null, $id = 0) {
        return self::push(self::build1($idItem, $idTypeEquipment, $id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_equipment_insert` (?,?,?,?)", [
            $object['Equipment_ShowOnBookingTour'],
            $object['Equipment_Status'],
            $object['Id_Item'],
            $object['Id_TypeEquipment']
        ]);
        $object['Id_Equipment'] = $response[0]->Response_Id;
        return $object;
    }

}