<?php

namespace App\DBRealTestSupport;

use Illuminate\Support\Facades\DB;
use Faker\Factory;

class BookingAssignMother
{

    public static function build1(
        $idBooking,
        $idAdmin,
        $idTypeBookingAssign = null,
        $id = 1
    ) {
        $faker = Factory::create();
        $idTypeBookingAssign = $idTypeBookingAssign ?? TypeBookingAssignMother::push1()['Id_TypeBookingAssign'];
        return [
            'Id_BookingAssign' => $id,
            'BookingAssign_Date' => date('Y-m-d H:i:s'),
            'BookingAssign_Remark' => $faker->text(rand(5, 500)),
            'BookingAssign_Status' => $faker->randomElement([1, 2]),
            'Id_Booking' => $idBooking,
            'Id_Admin' => $idAdmin,
            'Id_TypeBookingAssign' => $idTypeBookingAssign
        ];
    }

    public static function push1(
        $idBooking,
        $idAdmin,
        $idTypeBookingAssign = null,
        $id = 1
    ) {
        return self::push(
            self::build1(
                $idBooking,
                $idAdmin,
                $idTypeBookingAssign,
                $id
            )
        );
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_booking_assign_insert` (?,?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['BookingAssign_Remark'],
            $object['BookingAssign_Status'],
            $object['Id_Booking'],
            $object['Id_Admin'],
            $object['Id_TypeBookingAssign'],
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_BookingAssign'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return array_merge(
            [TableCreation::BOOKING_ASSIGN],
            BookingMother::clear(),
            AdminMother::tablesToClear(),
            TypeBookingAssignMother::tablesToClear()
        );
    }
}
