<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\ReviewSession\Domain\ReviewSessionRepository;
use App\Modules\ReviewSession\Infraestructure\MysqlReviewSessionRepository;

$router->post(
    '/reviewSession',
    [
        'uses' => 'ReviewSession\\ReviewSessionCreateController@__invoke'
    ]
);

$router->get(
    '/reviewSession',
    [
        'uses' => 'ReviewSession\\ReviewSessionIndexController@__invoke'
    ]
);

$router->get(
    '/reviewSession/detail/{idGroupProvider}',
    [
        'uses' => 'ReviewSession\\ReviewSessionDetailController@__invoke'
    ]
)->where('idGroupProvider', '[0-9]*');

$app->bind(ReviewSessionRepository::class, fn($app) => $app->make(MysqlReviewSessionRepository::class));
