<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\WebContact\Domain\WebContactRepository;
use App\Modules\WebContact\Infraestructure\MysqlWebContactRepository;

$app->bind(WebContactRepository::class, fn($app) => $app->make(MysqlWebContactRepository::class));

$router->post(
    '/webContact',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'WebContact\\WebContactInsertController@__invoke'
    ]
);

$router->put(
    '/webContact',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'WebContact\\WebContactUpdateController@__invoke'
    ]
);

$router->delete(
    '/webContact/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'WebContact\\WebContactDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/webContact/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'WebContact\\WebContactIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/webContact/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'WebContact\\WebContactListController@__invoke'
    ]
);
