<?php

/** @var \Laravel\Lumen\Routing\Router $router */

$router->post(
    '/tourHtlCamp',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Tour_Htl_Camp@Insert'
    ]
);

$router->put(
    '/tourHtlCamp',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Tour_Htl_Camp@Update'
    ]
);

$router->delete(
    '/tourHtlCamp/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Tour_Htl_Camp@Delete'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/tourHtlCamp/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Tour_Htl_Camp@Index'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/tour/{Id_Tour}/tourHtlCamp/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Tour_Htl_Camp@List'
    ]
)->where('Id_Tour', '[0-9]*');
