<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\StatusGroupProvider\Domain\StatusGroupProviderRepository;
use App\Modules\StatusGroupProvider\Infraestructure\MysqlStatusGroupProviderRepository;

$app->bind(StatusGroupProviderRepository::class, fn($app) => $app->make(MysqlStatusGroupProviderRepository::class));

$router->post(
    '/statusGroupProvider',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'StatusGroupProvider\\StatusGroupProviderInsertController@__invoke'
    ]
);

$router->put(
    '/statusGroupProvider',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'StatusGroupProvider\\StatusGroupProviderUpdateController@__invoke'
    ]
);

$router->delete(
    '/statusGroupProvider/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'StatusGroupProvider\\StatusGroupProviderDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/statusGroupProvider/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'StatusGroupProvider\\StatusGroupProviderIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/statusGroupProvider/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'StatusGroupProvider\\StatusGroupProviderListController@__invoke'
    ]
);
