<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderRepository;
use App\Modules\ProviderTypeProvider\Infraestructure\MysqlProviderTypeProviderRepository;

$app->bind(ProviderTypeProviderRepository::class, fn($app) => $app->make(MysqlProviderTypeProviderRepository::class));

$router->post(
    '/providerTypeProvider',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ProviderTypeProvider\\ProviderTypeProviderInsertController@__invoke'
    ]
);
$router->put(
    '/providerTypeProvider',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ProviderTypeProvider\\ProviderTypeProviderUpdateController@__invoke'
    ]
);
$router->delete(
    '/providerTypeProvider/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ProviderTypeProvider\\ProviderTypeProviderDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/providerTypeProvider/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ProviderTypeProvider\\ProviderTypeProviderIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/provider/{IdProvider}/providerTypeProvider/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ProviderTypeProvider\\ProviderTypeProviderListController@__invoke'
    ]
)->where('IdProvider', '[0-9]*');
