<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\PackageFee\Domain\PackageFeeRepository;
use App\Modules\PackageFee\Infrastructure\MysqlPackageFeeRepository;

$app->bind(
    PackageFeeRepository::class,
    fn ($app) => $app->make(MysqlPackageFeeRepository::class)
);


$router->post(
    '/packageFee/all',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Package_Fee@Insert_All'
    ]
);
$router->post(
    '/packageFee',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Package_Fee@Insert'
    ]
);

$router->put(
    '/packageFee',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Package_Fee@Update'
    ]
);

$router->delete(
    '/packageFee/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Package_Fee@Delete'
    ]
);

$router->get(
    '/packageFee/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Package_Fee@Index'
    ]
);

$router->get(
    '/package/{Id_Package}/packageFee',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Package_Fee@List'
    ]
);
