<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\LeadBookingTour\Domain\LeadBookingTourRepository;
use App\Modules\LeadBookingTour\Infraestructure\MysqlLeadBookingTourRepository;

$router->post(
    '/leadBookingTour',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingTour\\LeadBookingTourInsertController@__invoke'
    ]
);

$router->put(
    '/leadBookingTour',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingTour\\LeadBookingTourUpdateController@__invoke'
    ]
);

$router->delete(
    '/leadBookingTour/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingTour\\LeadBookingTourDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/leadBookingTour/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingTour\\LeadBookingTourIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/leadBooking/{Id_LeadBooking}/leadBookingTour/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingTour\\LeadBookingTourListController@__invoke'
    ]
)->where('Id_LeadBooking', '[0-9]*');

$app->bind(LeadBookingTourRepository::class, fn($app) => $app->make(MysqlLeadBookingTourRepository::class));
