<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\LeadBookingServicePassenger\Domain\LeadBookingServicePassengerRepository;
use App\Modules\LeadBookingServicePassenger\Infraestructure\MysqlLeadBookingServicePassengerRepository;

$router->post(
    '/leadBookingServicePassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingServicePassenger\\LeadBookingServicePassengerInsertController@__invoke'
    ]
);

$router->put(
    '/leadBookingServicePassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingServicePassenger\\LeadBookingServicePassengerUpdateController@__invoke'
    ]
);

$router->delete(
    '/leadBookingServicePassenger/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingServicePassenger\\LeadBookingServicePassengerDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/leadBookingServicePassenger/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingServicePassenger\\LeadBookingServicePassengerIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/leadBookingService/{Id_LeadBookingService}/leadBookingServicePassenger/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingServicePassenger\\LeadBookingServicePassengerListController@__invoke'
    ]
)->where('Id_LeadBookingService', '[0-9]*');

$app->bind(
    LeadBookingServicePassengerRepository::class,
    fn($app) => $app->make(MysqlLeadBookingServicePassengerRepository::class)
);
