<?php

/** @var \Laravel\Lumen\Routing\Router $router */

$router->post(
    '/htlUsage',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlUsage@Insert'
    ]
);

$router->put(
    '/htlUsage',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlUsage@Update'
    ]
);

$router->delete(
    '/htlUsage/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlUsage@Delete'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/htlUsage/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlUsage@Index'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/htlRoom/{Id_HtlRoom}/htlUsage/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlUsage@List'
    ]
)->where('Id_HtlRoom', '[0-9]*');

$router->get(
    '/htlCamp/{Id_HtlCamp}/htlUsage/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlUsage@CampList'
    ]
)->where('Id_HtlCamp', '[0-9]*');
