<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\FactCurrency\Domain\FactCurrencyRepository;
use App\Modules\FactCurrency\Infrastructure\MysqlFactCurrencyRepository;

$app->bind(FactCurrencyRepository::class, fn ($app) => $app->make(MysqlFactCurrencyRepository::class));

$router->post(
    '/factCurrency',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactCurrency\\FactCurrencyInsertController@__invoke'
    ]
);

$router->put(
    '/factCurrency',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactCurrency\\FactCurrencyUpdateController@__invoke'
    ]
);

$router->get(
    '/factCurrency/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactCurrency\\FactCurrencyIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/factCurrency/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactCurrency\\FactCurrencyListController@__invoke'
    ]
);

$router->delete(
    '/factCurrency/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactCurrency\\FactCurrencyDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);
