<?php

/** @var \Laravel\Lumen\Routing\Router $router */

$router->post(
    '/externalUser',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUser\\ExternalUserInsertController@__invoke'
    ]
);

$router->put(
    '/externalUser',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUser\\ExternalUserUpdateController@__invoke'
    ]
);

$router->delete(
    '/externalUser/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUser\\ExternalUserDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/externalUser/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUser\\ExternalUserIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/externalUser/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUser\\ExternalUserListController@__invoke'
    ]
);
