<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\Briefing\Domain\BriefingRepository;
use App\Modules\Briefing\Infrastructure\MysqlBriefingRepository;

$app->bind(BriefingRepository::class, fn ($app) => $app->make(MysqlBriefingRepository::class));

$router->get(
    '/briefing',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Briefing\\BriefingListController@__invoke'
    ]
);

$router->get(
    '/briefing/bookingTourPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Briefing\\BriefingListBookingTourPassengerController@__invoke'
    ]
);

$router->get(
    '/briefing/groupPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Briefing\\BriefingListGroupPassengerController@__invoke'
    ]
);
