<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\BookingExtraPassenger\Domain\BookingExtraPassengerRepository;
use App\Modules\BookingExtraPassenger\Infrastructure\MysqlBookingExtraPassengerRepository;

$app->bind(BookingExtraPassengerRepository::class, fn ($app) => $app->make(MysqlBookingExtraPassengerRepository::class));

$router->put(
    '/bookingExtraPassenger/{Id}/reset',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingExtraPassenger\\BookingExtraPassengerResetController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->put(
    '/bookingExtraPassenger/mask',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingExtraPassenger\\BookingExtraPassengerMaskController@__invoke'
    ]
);

$router->post(
    '/bookingExtraPassenger/all',
    [
        'middleware' => 'Auth_Owner', 'uses' => 'BookingExtraPassenger@Insert_All'
    ]
);
$router->post(
    '/bookingExtraPassenger',
    [
        'middleware' => 'Auth_Owner', 'uses' => 'BookingExtraPassenger@Insert'
    ]
);
$router->put(
    '/bookingExtraPassenger',
    [
        'middleware' => 'Auth_Owner', 'uses' => 'BookingExtraPassenger@Update'
    ]
);
$router->put(
    '/bookingExtraPassenger/simple',
    [
        'middleware' => 'Auth_Owner', 'uses' => 'BookingExtraPassenger@simpleUpdate'
    ]
);
$router->delete(
    '/bookingExtraPassenger/{Id}',
    [
        'middleware' => 'Auth_Owner', 'uses' => 'BookingExtraPassenger@Delete'
    ]
)->where('Id', '[0-9]*');

$router->get(
    '/bookingExtraPassenger/listByIds',
    [
        'middleware' => 'Auth_Owner', 'uses' => 'BookingExtraPassenger\\BookingExtraPassengerByIdsController@__invoke'
    ]
);

$router->put(
    '/bookingExtraPassenger/massive',
    [
        'middleware' => 'Auth_Owner', 'uses' => 'BookingExtraPassenger\\BookingExtraPassengerMassiveUpdateController@__invoke'
    ]
);

$router->get(
    '/bookingExtraPassenger/{Id}',
    [
        'middleware' => 'Auth_Owner', 'uses' => 'BookingExtraPassenger@Index'
    ]
)->where('Id', '[0-9]*');

$router->get(
    '/bookingExtra/{Id_BookingExtra}/bookingExtraPassenger',
    [
        'middleware' => 'Auth_Owner', 'uses' => 'BookingExtraPassenger@List'
    ]
);
$router->get(
    '/bookingExtra/bookingExtraPassenger/search',
    [
        'middleware' => 'Auth_Owner', 'uses' => 'BookingExtraPassenger@Search'
    ]
);
$router->get(
    '/bookingExtra/bookingExtraPassenger/exportExcel',
    [
        'uses' => 'BookingExtraPassenger@ExportExcel'
    ]
);
