<?php

namespace App\Providers\User\BookingReport;

use App\Providers\ExcelReport\Utils;

class ReportCells
{

    private const BASIC_BACKGROUND = 'FF707070';
    private const BASIC_COLOR_ACTIVE = 'FF000000';

    private function tableTitle($data)
    {
        $fnPrint = Utils::print($data[0]);
        $fnWidth = Utils::width($data[1]);
        $fnBackground = Utils::background($data[2]);
        $fnColor = Utils::color('FFFFFFFF');
        return $fnColor($fnBackground(Utils::wrap(Utils::top(Utils::border(Utils::bold(Utils::center($fnPrint($fnWidth(Utils::cell())))))))));
    }

    private function tableCellLeft($text, $color)
    {
        $fnPrint = Utils::print($text);
        $fnColor = Utils::color($color);
        $fns = Utils::compose($fnColor);
        return Utils::wrap(Utils::top($fns(Utils::left($fnPrint(Utils::cell())))));
    }

    private function tableCellRight($text, $color)
    {
        $fnPrint = Utils::print($text);
        $fnColor = Utils::color($color);
        $fns = Utils::compose($fnColor);
        return Utils::wrap(Utils::top($fns(Utils::right($fnPrint(Utils::cell())))));
    }

    private function getAllRows(UserReportBookingDataCollection $data)
    {
        return array_map(fn ($b, $k) => $this->getRow($b, $k), array_values($data->data()), array_keys($data->data()));
    }

    private function getRow(UserReportBookingData $booking, $key)
    {
        // $color = $booking->BookingTourPassenger_Status > 0 ? self::BASIC_COLOR_ACTIVE : self::BASIC_COLOR_INACTIVE;
        $color = self::BASIC_COLOR_ACTIVE;

        return array_merge(
            [
                $this->tableCellLeft($key + 1, $color),
                $this->tableCellLeft($booking->Booking_PassengerAmount, $color),
                $this->tableCellLeft($booking->Booking_Code, $color),
                $this->tableCellLeft($booking->Booking_Date, $color),
                $this->tableCellLeft($booking->Contact_Name, $color),
                $this->tableCellLeft($booking->User_Email, $color),
                $this->tableCellLeft($booking->Booking_Type, $color),
                $this->tableCellLeft($booking->Admin_Name . ' ' . $booking->Admin_LastName, $color),
                $this->tableCellLeft($booking->Package_Duration, $color),
                $this->tableCellLeft($booking->Package_Code, $color),
                $this->tableCellLeft($booking->Tour_Code, $color),
                $this->tableCellLeft($booking->BookingTour_DateStart, $color),
                $this->tableCellRight(isset($booking->BookingTourPassenger_Price) ? '$' . $booking->BookingTourPassenger_Price : 'S/T', $color),
            ]
        );
    }

    public function run(UserReportBookingDataCollection $data, $metadata)
    {
        return array_merge(
            [
                array_merge(
                    array_map([$this, 'tableTitle'], [
                        ['N°', 5, self::BASIC_BACKGROUND],
                        ['PAXS', 8, self::BASIC_BACKGROUND],
                        ['BOOKING', 12, self::BASIC_BACKGROUND],
                        ['REGISTRO', 12, self::BASIC_BACKGROUND],
                        ['CONTACTO', 28, self::BASIC_BACKGROUND],
                        ['EMAIL', 28, self::BASIC_BACKGROUND],
                        ['TIPO', 18, self::BASIC_BACKGROUND],
                        ['VENDEDOR', 24, self::BASIC_BACKGROUND],
                        ['DÍAS', 6, self::BASIC_BACKGROUND],
                        ['PAQUETE', 14, self::BASIC_BACKGROUND],
                        ['TOUR', 14, self::BASIC_BACKGROUND],
                        ['F. SALIDA', 12, self::BASIC_BACKGROUND],
                        ['TARIFA', 12, self::BASIC_BACKGROUND],
                    ]),
                ),
            ],
            $this->getAllRows($data)
        );
    }
}
