<?php

namespace App\Providers\ExcelGroupReviewsReport;

use App\Providers\ExcelReport\ExcelReport;

class ExcelGroupReviewsReport {

    public function exportToExcel($oGroups) {
        $title = 'REPORTE DE REVIEWS';
        if (count($oGroups)) {
            $title .= ' - ' . $oGroups[0]->Group_Name;
        }
        $report = new ExcelReport();

        $report->exportToExcel(
            $oGroups,
            (object)[
                'title' => $title,
                'rowLength' => 1
            ],
            [
                new ColumnsWidth(),
                new GroupCells(),
                new PassengerCells()
            ],
        );
    }
}