<?php

namespace App\Modules\WebContactMessageDetail\Application\List;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\WebContact\Domain\IdWebContact;
use App\Modules\WebContactMessage\Domain\IdWebContactMessage;
use App\Modules\WebContactMessageDetail\Application\List\ListWebContactMessageDetailQueryResponse;
use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetailRepository;

final class WebContactMessageDetailLister
{
    public function __construct(private WebContactMessageDetailRepository $repository)
    {
    }

    public function __invoke(IdWebContactMessage $idWebContactMessage, string $action): ListWebContactMessageDetailQueryResponse
    {
        return new ListWebContactMessageDetailQueryResponse($this->repository->find($idWebContactMessage, $action));
    }
}
