<?php

namespace App\Modules\WebContactMessage\Infraestructure;

class WebContactMessageValidators
{
    public const INSERT_CLIENT = [
        'WebContact_Name'                   => 'string|max:250',
        'WebContact_LastName'               => 'string|max:250',
        'WebContact_Email'                  => 'string|email|max:255',
        'WebContact_Country'                => 'string|max:250',
        'WebContact_CountryCurrent'         => 'string|max:250',
        'WebContact_PhoneCode'              => 'string|max:10',
        'WebContact_Phone'                  => 'string|max:100',
        'Id_Country'                        => 'int',
        'Id_Country_Current'                => 'int',
        'WebContactMessage_Message'         => 'string|max:2000',
        'WebContactMessage_Adults'          => 'int|min:0|max:100',
        'WebContactMessage_Children'        => 'int|min:0|max:100',
        'WebContactMessage_Subscription'    => 'int',
        'WebContactMessage_Origin'          => 'string|max:1000',
        'WebContactMessage_Type'            => 'int',
        'Id_Language'                       => 'int',
        'WebContactMessageDetail'           => 'array',
        'WebContactMessageDetail.*.WebContactMessageDetail_Package' => 'string|max:250',
        'WebContactMessageDetail.*.WebContactMessageDetail_DateStart' => 'string|date',
        'WebContactMessageDetail.*.Id_Package' => 'int',
    ];

    public const INSERT = [
        'WebContactMessage_Name'            => 'string|max:250',
        'WebContactMessage_LastName'        => 'string|max:250',
        'WebContactMessage_Email'           => 'string|email|max:255',
        'WebContactMessage_Country'         => 'string|max:250',
        'WebContactMessage_CountryCurrent'  => 'string|max:250',
        'WebContactMessage_PhoneCode'       => 'string|max:10',
        'WebContactMessage_Phone'           => 'string|max:100',
        'Id_Country'                        => 'int',
        'Id_Country_Current'                => 'int',
        'WebContactMessage_Message'         => 'required|string|max:1000',
        'WebContactMessage_Adults'          => 'required|int|min:0|max:100',
        'WebContactMessage_Children'        => 'required|int|min:0|max:100',
        'WebContactMessage_Subscription'    => 'required|int',
        'WebContactMessage_Origin'          => 'string|max:1000',
        'WebContactMessage_Type'            => 'int',
        'WebContactMessage_Status'          => 'required|int',
        'Id_WebContact'                     => 'required|int',
        'Id_Language'                       => 'required|int',
    ];

    public const UPDATE = [
        'Id_WebContactMessage'      => 'required|int',
        'WebContactMessage_Message' => 'required|string|max:1000',
        'WebContactMessage_Adults'  => 'required|int|min:1|max:100',
        'WebContactMessage_Children' => 'required|int|min:1|max:100',
        'WebContactMessage_Subscription' => 'required|int',
        'WebContactMessage_Status'  => 'required|int',
        'Id_WebContact'             => 'required|int',
    ];

    public const LIST_ALL = [
        'DateStart' => 'required|string|date',
        'DateEnd' => 'required|string|date',
    ];
}
