<?php

namespace App\Modules\WebContactMessage\Application\Index;

use App\Modules\WebContactMessage\Domain\IdWebContactMessage;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexWebContactMessageQueryHandler implements QueryHandler
{
    public function __construct(private WebContactMessageIndexer $inserter)
    {
    }

    public function __invoke(IndexWebContactMessageQuery $query): IndexWebContactMessageQueryResponse
    {
        return $this->inserter->__invoke(new IdWebContactMessage($query->getId()));
    }
}
