<?php

namespace App\Modules\WebContact\Application\List;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\WebContact\Application\List\ListWebContactQueryResponse;
use App\Modules\WebContact\Domain\WebContactRepository;

final class WebContactLister
{
    public function __construct(private WebContactRepository $repository)
    {
    }

    public function __invoke(string $action): ListWebContactQueryResponse
    {
        return new ListWebContactQueryResponse($this->repository->find($action));
    }
}
