<?php

namespace App\Modules\WebContact\Application\Create;

use App\Modules\WebContact\Application\Create\CreateWebContactResponse;
use App\Modules\WebContact\Domain\WebContact;
use App\Modules\WebContact\Domain\WebContactRepository;

final class WebContactCreator
{
    public function __construct(private WebContactRepository $repository)
    {
    }

    public function __invoke(WebContact $webContact): CreateWebContactResponse
    {
        return new CreateWebContactResponse($this->repository->insert($webContact));
    }
}
