<?php

namespace App\Modules\TypeProvider\Domain;

use App\Modules\Shared\Domain\ValueObject\IntValueObject;

class IdTypeProvider extends IntValueObject
{

    public const HORSE_MAN = 4;

    public const GUIDES_WHERE = '1, 2, 11, 12, 13';
    public const GUIDES = [1, 2, 11, 12, 13];
    public const COOKS = [3];

    public static function findGuides($providerList)
    {
        return self::findTypeProvider($providerList, self::GUIDES);
    }

    public static function findCooks($providerList)
    {
        return self::findTypeProvider($providerList, self::COOKS);
    }

    public static function findTypeProvider($providerList, $typeProviderList)
    {
        $foundProviders = [];
        foreach ($providerList as $cur) {
            if (in_array($cur->Id_TypeProvider, $typeProviderList)) {
                $foundProviders[] = $cur;
            }
        }
        if (count($foundProviders) > 0) {
            // get provider from $typeProviderList list
            foreach ($typeProviderList as $guideType) {
                foreach ($foundProviders as $cur) {
                    if ($cur->Id_TypeProvider == $guideType) {
                        return $cur;
                    }
                }
            }
        }
        return null;
    }
}
