<?php

namespace App\Modules\TypeBookingAssign\Application\Index;

use App\Modules\TypeBookingAssign\Application\Index\IndexTypeBookingAssignQueryResponse;
use App\Modules\TypeBookingAssign\Domain\IdTypeBookingAssign;
use App\Modules\TypeBookingAssign\Domain\TypeBookingAssign;
use App\Modules\TypeBookingAssign\Domain\TypeBookingAssignRepository;

final class TypeBookingAssignIndexer
{
    public function __construct(private TypeBookingAssignRepository $repository)
    {
    }

    public function __invoke(IdTypeBookingAssign $idTypeBookingAssign): IndexTypeBookingAssignQueryResponse
    {
        return new IndexTypeBookingAssignQueryResponse($this->repository->index($idTypeBookingAssign));
    }
}
