<?php

namespace App\Modules\TypeBookingAssign\Application\Index;

use App\Modules\TypeBookingAssign\Domain\IdTypeBookingAssign;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexTypeBookingAssignQueryHandler implements QueryHandler
{
    public function __construct(private TypeBookingAssignIndexer $inserter)
    {
    }

    public function __invoke(IndexTypeBookingAssignQuery $query): IndexTypeBookingAssignQueryResponse
    {
        return $this->inserter->__invoke(new IdTypeBookingAssign($query->getId()));
    }
}
