<?php

namespace App\Modules\StatusGroupProvider\Application\Index;

use App\Modules\StatusGroupProvider\Domain\IdStatusGroupProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexStatusGroupProviderQueryHandler implements QueryHandler
{
    public function __construct(private StatusGroupProviderIndexer $inserter)
    {
    }

    public function __invoke(IndexStatusGroupProviderQuery $query): IndexStatusGroupProviderQueryResponse
    {
        return $this->inserter->__invoke(new IdStatusGroupProvider($query->getId()));
    }
}
