<?php

namespace App\Modules\StatusGroupProvider\Application\Delete;

use App\Modules\StatusGroupProvider\Domain\IdStatusGroupProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteStatusGroupProviderQueryHandler implements QueryHandler
{
    public function __construct(private StatusGroupProviderDeleter $inserter)
    {
    }

    public function __invoke(DeleteStatusGroupProviderQuery $query): DeleteStatusGroupProviderQueryResponse
    {
        return $this->inserter->__invoke(new IdStatusGroupProvider($query->getId()));
    }
}
