<?php

namespace App\Modules\StatusGroupProvider\Application\Create;

use App\Modules\StatusGroupProvider\Domain\StatusGroupProvider;
use App\Modules\StatusGroupProvider\Domain\StatusGroupProviderColor;
use App\Modules\StatusGroupProvider\Domain\StatusGroupProviderAbrv;
use App\Modules\StatusGroupProvider\Domain\StatusGroupProviderName;
use App\Modules\StatusGroupProvider\Domain\StatusGroupProviderStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateStatusGroupProviderQueryHandler implements QueryHandler
{
    public function __construct(private StatusGroupProviderCreator $inserter)
    {
    }

    public function __invoke(CreateStatusGroupProviderQuery $query): CreateStatusGroupProviderResponse
    {
        $model = new StatusGroupProvider(
            new StatusGroupProviderName($query->name()),
            new StatusGroupProviderAbrv($query->abrev()),
            new StatusGroupProviderColor($query->color()),
            new StatusGroupProviderStatus($query->status()),
        );
        return $this->inserter->__invoke($model);
    }
}
