<?php

namespace App\Modules\StatusGroup\Infraestructure;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\Shared\Infraestructure\RequestChecker;
use App\Modules\StatusGroup\Domain\StatusGroup;
use App\Modules\StatusGroup\Domain\StatusGroupRepository;
use App\Modules\StatusGroup\Domain\IdStatusGroup;

class MysqlStatusGroupRepository implements StatusGroupRepository
{

    public function find(string $action)
    {
        return RequestChecker::requestSelect(
            'CALL sp_status_group_list(?,@sts,@cod,@msg)',
            [
                $action
            ]
        );
    }

    public function index(IdStatusGroup $id)
    {
        return RequestChecker::requestSelect(
            'CALL sp_status_group_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(StatusGroup $value)
    {
        return RequestChecker::requestInsert(
            'CALL sp_status_group_insert(?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->name()->value(),
                $value->abrev()->value(),
                $value->color()->value(),
                $value->status()->value(),
            ]
        );
    }

    public function update(StatusGroup $value)
    {
        return RequestChecker::requestUpdate(
            'CALL sp_status_group_update(?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->name()->value(),
                $value->abrev()->value(),
                $value->color()->value(),
                $value->status()->value(),
            ]
        );
    }

    public function delete(IdStatusGroup $id)
    {
        return RequestChecker::requestUpdate(
            'CALL sp_status_group_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
