<?php

namespace App\Modules\StatusGroup\Application\Index;

use App\Modules\StatusGroup\Application\Index\IndexStatusGroupQueryResponse;
use App\Modules\StatusGroup\Domain\IdStatusGroup;
use App\Modules\StatusGroup\Domain\StatusGroup;
use App\Modules\StatusGroup\Domain\StatusGroupRepository;

final class StatusGroupIndexer
{
    public function __construct(private StatusGroupRepository $repository)
    {
    }

    public function __invoke(IdStatusGroup $idStatusGroup): IndexStatusGroupQueryResponse
    {
        return new IndexStatusGroupQueryResponse($this->repository->index($idStatusGroup));
    }
}
